#**************************************************************************/
#* PROJECT: Interrupts in Decoupled Parallel Mode for MPC5675K            */ 
#* FILE NAME:                              			          */
#* Vector_SW_VLE - Z3_Z4_Z6_Z7_1.s                 			  */
#*                                                                        */
#* DESCRIPTION:                                                           */
#* This is a generic base template for setting up the IVPR and IVOR       */
#* registers for the e200z3, z4, z6 and z7 cores.                         */
#*                                                                        */
#* This file also includes a trap for all core exceptions, excluding      */
#* IVOR4 exceptions which have seperate handler                           */
#*                                                                        */
#* Syntax specifically written for GHS v5.x compiler. This file starts in */
#* memory at the beginning of the ".xptn_vectors1" section.                */
#=========================================================================*/
#*                                                                        */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1    R. Moran       10/12/2008    Initial Version                    */
#**************************************************************************/
#**************************************************************************/
#*  LICENSE: 
#*  Copyright (c) 2012 Freescale Semiconductor
#*  
#*  Permission is hereby granted, free of charge, to any person 
#*  obtaining a copy of this software and associated documentation 
#*  files (the "Software"), to deal in the Software without 
#*  restriction, including without limitation the rights to use, 
#*  copy, modify, merge, publish, distribute, sublicense, and/or 
#*  sell copies of the Software, and to permit persons to whom the 
#*  Software is furnished to do so, subject to the following 
#*  conditions:
#*  
#*  The above copyright notice and this permission notice 
#*  shall be included in all copies or substantial portions 
#*  of the Software.
#*  
#*  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
#*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
#*  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
#*  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
#*  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
#*  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
#*  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
#*  DEALINGS IN THE SOFTWARE.
#***************************************************************************/
    .globl   IVOR0_Handler_1
    .globl   IVOR1_Handler_1
    .globl   IVOR2_Handler_1
    .globl   IVOR3_Handler_1

    .globl   IVOR5_Handler_1
    .globl   IVOR6_Handler_1
    .globl   IVOR7_Handler_1
    .globl   IVOR8_Handler_1
    .globl   IVOR9_Handler_1
    .globl   IVOR10_Handler_1
    .globl   IVOR11_Handler_1
    .globl   IVOR12_Handler_1
    .globl   IVOR13_Handler_1
    .globl   IVOR14_Handler_1
    .globl   IVOR15_Handler_1

    .globl   e200zX_Interrupt_Setup_1
    
    .section    ".xptn_vectors1", "va"
    .vle

.align 4    
IVORnTable_1:    
#=================================================
#               IVOR 0 Handler
#=================================================           
IVOR0_Handler_1:
    nop
    e_b IVOR0_Handler_1
#=================================================
#               IVOR 1 Handler
#=================================================           
.offset 0x10
IVOR1_Handler_1:
    nop
    e_b IVOR1_Handler_1
#=================================================
#               IVOR 2 Handler
#=================================================              
.offset 0x20
IVOR2_Handler_1:
    nop
    e_b IVOR2_Handler_1
#=================================================
#               IVOR 3 Handler
#=================================================              
.offset 0x30
IVOR3_Handler_1:
    nop
    e_b IVOR3_Handler_1
#=================================================
#               IVOR 4 Handler
#================================================= 

# IVOR 4 Handled in seperate file

#=================================================
#               IVOR 5 Handler
#=================================================              
.offset 0x50
IVOR5_Handler_1:
    nop
    e_b IVOR5_Handler_1
#=================================================
#               IVOR 6 Handler
#=================================================              
.offset 0x60
IVOR6_Handler_1:
    nop
    e_b IVOR6_Handler_1
#=================================================
#               IVOR 7 Handler
#=================================================              
.offset 0x70
IVOR7_Handler_1:
    nop
    e_b IVOR7_Handler_1
#=================================================
#               IVOR 8 Handler
#=================================================              
.offset 0x80
IVOR8_Handler_1:
    nop
    e_b IVOR8_Handler_1
#=================================================
#               IVOR 9 Handler
#=================================================              
.offset 0x90
IVOR9_Handler_1:
    nop
    e_b IVOR9_Handler_1
#=================================================
#               IVOR 10 Handler
#=================================================              
.offset 0x100
IVOR10_Handler_1:
    nop
    e_b IVOR10_Handler_1    
#=================================================
#               IVOR 11 Handler
#=================================================              
.offset 0x110
IVOR11_Handler_1:
    nop
    e_b IVOR11_Handler_1    
#=================================================
#               IVOR 12 Handler
#=================================================              
.offset 0x120
IVOR12_Handler_1:
    nop
    e_b IVOR12_Handler_1
#=================================================
#               IVOR 13 Handler
#=================================================              
.offset 0x130
IVOR13_Handler_1:
    nop
    e_b IVOR13_Handler_1
#=================================================
#               IVOR 14 Handler
#=================================================              
.offset 0x140
IVOR14_Handler_1:
    nop
    e_b IVOR14_Handler_1                                                  
#=================================================
#               IVOR 15 Handler
#=================================================              
.offset 0x150
IVOR15_Handler_1:                             
    nop                           
    e_b IVOR15_Handler_1                                                              
    

#=================================================
#  Function to Setup the Core Interrupt Registers
#=================================================              
e200zX_Interrupt_Setup_1:

    #IVPR = address base used with IVOR's
    e_lis r5, __IVPR1@h   
    e_or2i r5, __IVPR1@l
    mtIVPR r5 
    
    # Setup IVORx Registers
    e_lis r5, IVOR0_Handler_1@h
    e_or2i r5, IVOR0_Handler_1@l
    mtIVOR0 r5
    
    e_lis r5, IVOR1_Handler_1@h
    e_or2i r5, IVOR1_Handler_1@l
    mtIVOR1 r5
    
    e_lis r5, IVOR2_Handler_1@h
    e_or2i r5, IVOR2_Handler_1@l
    mtIVOR2 r5
    
    e_lis r5, IVOR3_Handler_1@h
    e_or2i r5, IVOR3_Handler_1@l
    mtIVOR3 r5
    
    e_lis r5, IVOR4_Handler_1@h
    e_or2i r5, IVOR4_Handler_1@l
    mtIVOR4 r5
    
    e_lis r5, IVOR5_Handler_1@h
    e_or2i r5, IVOR5_Handler_1@l
    mtIVOR5 r5
    
    e_lis r5, IVOR6_Handler_1@h
    e_or2i r5, IVOR6_Handler_1@l
    mtIVOR6 r5
    
    e_lis r5, IVOR7_Handler_1@h
    e_or2i r5, IVOR7_Handler_1@l
    mtIVOR7 r5
    
    e_lis r5, IVOR8_Handler_1@h
    e_or2i r5, IVOR8_Handler_1@l
    mtIVOR8 r5
    
    e_lis r5, IVOR9_Handler_1@h
    e_or2i r5, IVOR9_Handler_1@l
    mtIVOR9 r5
    
    e_lis r5, IVOR10_Handler_1@h
    e_or2i r5, IVOR10_Handler_1@l
    mtIVOR10 r5
    
    e_lis r5, IVOR11_Handler_1@h
    e_or2i r5, IVOR11_Handler_1@l
    mtIVOR11 r5
    
    e_lis r5, IVOR12_Handler_1@h
    e_or2i r5, IVOR12_Handler_1@l
    mtIVOR12 r5
    
    e_lis r5, IVOR13_Handler_1@h
    e_or2i r5, IVOR13_Handler_1@l
    mtIVOR13 r5
    
    e_lis r5, IVOR14_Handler_1@h
    e_or2i r5, IVOR14_Handler_1@l
    mtIVOR14 r5
    
    e_lis r5, IVOR15_Handler_1@h
    e_or2i r5, IVOR15_Handler_1@l
    mtIVOR15 r5
    
    se_blr
    
